/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.richtext.v2_1;

import com.roguewave.chart.core.v2_1.graphics.ImageLoader;
import com.roguewave.chart.richtext.v2_1.AlignedBlock;
import com.roguewave.chart.richtext.v2_1.ColorBlock;
import com.roguewave.chart.richtext.v2_1.FontBlock;
import com.roguewave.chart.richtext.v2_1.HConcatenation;
import com.roguewave.chart.richtext.v2_1.HTMLStyleTokenizer;
import com.roguewave.chart.richtext.v2_1.ImageBlock;
import com.roguewave.chart.richtext.v2_1.PlainText;
import com.roguewave.chart.richtext.v2_1.RedrawObserver;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import com.roguewave.chart.richtext.v2_1.UnderlineBlock;
import com.roguewave.chart.richtext.v2_1.VConcatenation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;

public class HTMLStyleParser {
    public static TextBlock parse(String text, Component component) {
        Vector<String> tokens = new Vector<String>();
        long startTime = System.currentTimeMillis();
        HTMLStyleTokenizer tokenizer = new HTMLStyleTokenizer(text);
        long endTime = System.currentTimeMillis();
        while (tokenizer.hasMoreElements()) {
            tokens.addElement(tokenizer.nextToken());
        }
        int start = 0;
        int end = tokens.size();
        startTime = System.currentTimeMillis();
        TextBlock block = HTMLStyleParser.parse1(tokens, start, end, component);
        endTime = System.currentTimeMillis();
        return block;
    }

    private static TextBlock parse1(Vector tokens, int start, int end, Component component) {
        Vector results = new Vector();
        while (start < end) {
            int newstart = HTMLStyleParser.rule1(tokens, start, results);
            if (newstart > start) {
                start = newstart;
                continue;
            }
            newstart = HTMLStyleParser.rule2(tokens, start, end, results, component);
            if (newstart > start) {
                start = newstart;
                continue;
            }
            throw new IllegalArgumentException("HTMLStyleParser: parse failure");
        }
        if (results.size() > 1) {
            int[] newlines = new int[results.size() + 1];
            int count = 0;
            for (int i = 0; i < results.size(); ++i) {
                if (results.elementAt(i) != null) continue;
                newlines[count++] = i;
            }
            if (count == 0) {
                HConcatenation hcat = new HConcatenation();
                for (int i = 0; i < results.size(); ++i) {
                    hcat.addBlock((TextBlock)results.elementAt(i));
                }
                return hcat;
            }
            newlines[count++] = results.size();
            VConcatenation vcat = new VConcatenation();
            int first = 0;
            for (int i = 0; i < count; ++i) {
                int items = newlines[i] - first;
                if (items == 0) {
                    vcat.addBlock(new PlainText(""));
                } else if (items == 1) {
                    vcat.addBlock((TextBlock)results.elementAt(first));
                } else {
                    HConcatenation hcat = new HConcatenation();
                    for (int j = first; j < newlines[i]; ++j) {
                        hcat.addBlock((TextBlock)results.elementAt(j));
                    }
                    vcat.addBlock(hcat);
                }
                first = newlines[i] + 1;
            }
            return vcat;
        }
        if (results.elementAt(0) == null) {
            return new PlainText("");
        }
        return (TextBlock)results.elementAt(0);
    }

    private static int rule1(Vector tokens, int start, Vector results) {
        String token0 = (String)tokens.elementAt(start);
        if (token0.charAt(0) != '<') {
            results.addElement(new PlainText(token0));
            return start + 1;
        }
        return start;
    }

    private static int rule2(Vector tokens, int start, int end, Vector results, Component component) {
        int endName;
        String token0 = ((String)tokens.elementAt(start)).toLowerCase();
        if (token0.equals("<br>")) {
            results.addElement(null);
            return start + 1;
        }
        if (token0.length() > 4 && token0.substring(0, 4).equals("<img")) {
            Vector argVector = HTMLStyleParser.parseArgs(token0.substring(5, token0.length() - 1));
            for (int i = 0; i < argVector.size(); ++i) {
                String arg = (String)argVector.elementAt(i);
                if (!arg.substring(0, 4).equals("src=")) continue;
                Image image = HTMLStyleParser.load(arg.substring(4), component);
                if (image != null) {
                    RedrawObserver observer = new RedrawObserver(component);
                    results.addElement(new ImageBlock(image, observer));
                }
                return start + 1;
            }
        }
        String tagName = (endName = token0.indexOf(32)) == -1 ? token0.substring(1, token0.length() - 1).toLowerCase() : token0.substring(1, endName).toLowerCase();
        String endToken = String.valueOf(String.valueOf("</").concat(String.valueOf(tagName))).concat(String.valueOf(">"));
        int endIndex = -1;
        int nesting = 0;
        for (int i = start + 1; i < end; ++i) {
            String tokenI = ((String)tokens.elementAt(i)).toLowerCase();
            if (tokenI.equals(String.valueOf(String.valueOf("<").concat(String.valueOf(tagName))).concat(String.valueOf(">"))) || tokenI.startsWith(String.valueOf(String.valueOf("<").concat(String.valueOf(tagName))).concat(String.valueOf(" ")))) {
                ++nesting;
            }
            if (!tokenI.equals(endToken)) continue;
            if (nesting == 0) {
                endIndex = i;
                break;
            }
            --nesting;
        }
        if (endIndex == -1) {
            throw new IllegalArgumentException(String.valueOf("unmatched token ").concat(String.valueOf(token0)));
        }
        TextBlock block = HTMLStyleParser.parse1(tokens, start + 1, endIndex, component);
        if (token0.equals("<i>")) {
            results.addElement(new FontBlock(block, 2));
        } else if (token0.equals("<b>")) {
            results.addElement(new FontBlock(block, 1));
        } else if (token0.equals("<r>")) {
            results.addElement(new FontBlock(block, 0, false));
        } else if (token0.equals("<underline>")) {
            results.addElement(new UnderlineBlock(block));
        } else if (token0.equals("<center>")) {
            if (results.size() != 0 && results.elementAt(results.size() - 1) != null) {
                results.addElement(null);
            }
            results.addElement(new AlignedBlock(block, 1));
            results.addElement(null);
        } else if (endName != -1 && token0.substring(0, endName).equals("<font")) {
            Vector argVector = HTMLStyleParser.parseArgs(token0.substring(endName + 1, token0.length() - 1));
            for (int i = 0; i < argVector.size(); ++i) {
                String arg = (String)argVector.elementAt(i);
                if (arg.length() > 5 && arg.substring(0, 5).equals("size=")) {
                    String numericString = arg.substring(5, arg.length());
                    try {
                        int size = Integer.parseInt(numericString);
                        block = new FontBlock(block, 0, size);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.valueOf("Bad size spec: ").concat(String.valueOf(arg)));
                    }
                }
                if (arg.length() > 6 && arg.substring(0, 6).equals("color=")) {
                    String colorString = arg.substring(6, arg.length());
                    Color color = HTMLStyleParser.lookup(colorString);
                    if (color != null) {
                        block = HTMLStyleParser.ie4Fix(new ColorBlock(block, color));
                        continue;
                    }
                    throw new IllegalArgumentException(String.valueOf(String.valueOf("Bad color spec: \"").concat(String.valueOf(arg))).concat(String.valueOf("\"")));
                }
                System.out.println(String.valueOf("font argument ignored: ").concat(String.valueOf(arg)));
            }
            results.addElement(block);
        } else {
            results.addElement(block);
        }
        return endIndex + 1;
    }

    private static TextBlock ie4Fix(TextBlock block) {
        return block;
    }

    private static Color lookup(String colorString) {
        if (colorString.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (colorString.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (colorString.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (colorString.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (colorString.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (colorString.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (colorString.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (colorString.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (colorString.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (colorString.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (colorString.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (colorString.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (colorString.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return null;
    }

    private static Vector parseArgs(String argString) {
        StringTokenizer tokenizer = new StringTokenizer(argString);
        Vector<String> args = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            args.addElement(tokenizer.nextToken());
        }
        return args;
    }

    public static Image load(String imageFileName, Component component) {
        Image image = ImageLoader.load(imageFileName, component, true);
        return image;
    }
}

